function Sequence1_event_create()
{
	/*
	All audio tracks in a sequence use positional audio played from an emitter. However, if your sequence is not perfectly aligned with the room and the default emitter position, then
	you might hear your audio offset in some way from where you were expecting it.
	
	This is not a bug, but it is something you will need to account for/control by setting the listener's position and orientation.
	
	You can find the current version of this project and more info at https://help.yoyogames.com/hc/en-us/articles/360018747138
	*/
	
	// First we will position our listener in the centre of the game window, so that we hear positional audio play across both speakers as the sound source moves:
	audio_listener_position(window_get_width()/2, window_get_height()/2, 0); 
	
	// Then we will flip the "up Y" orientation from the default 1 to be -1, so that we're now "looking into the screen" and sounds will play out of the left/right speakers as players will expect:
	audio_listener_orientation(0, 0, 1000, 0, -1 ,0);
}


function Sequence1_event_destroy()
{

}

function Sequence1_event_clean_up()
{

}

function Sequence1_event_step()
{

}

function Sequence1_event_step_begin()
{

}

function Sequence1_event_step_end()
{

}

function Sequence1_event_async_system()
{

}