/// @desc Process changes received from the Companion app

if !variable_instance_exists(id, "config")
{
	config = {};
}

var _config = wallpaper_config;

if variable_struct_exists(_config, "animation")
{
	// The "anim" section exists, assign its properties to this instance's config struct
	var _config_anim = _config.animation;
	
	if (variable_struct_exists(_config_anim, "speed"))
	{
		config.speed = _config_anim.speed;
	}
	
	if (variable_struct_exists(_config_anim, "clockwiseRotation"))
	{
		config.clockwiseRotation = _config_anim.clockwiseRotation;
	}
	
	if (variable_struct_exists(_config_anim, "pause"))
	{
		config.pause = _config_anim.pause;
	}
}
	
if variable_struct_exists(_config, "colours")
{
	// The "colours" section exists, assign its properties to this instance's config struct
	var _config_colours = _config.colours;
	
	if (variable_struct_exists(_config_colours, "blendColor"))
	{	
		config.blendColor = _config_colours.blendColor;
		image_blend = _config_colours.blendColor;
	}

	if (variable_struct_exists(_config_colours, "blendAlpha"))
	{	
		config.blendAlpha = _config_colours.blendAlpha;
		image_alpha = _config_colours.blendAlpha / 100;
	}
}